local t = Def.ActorFrame {};
local failWait = 2;

t[#t+1] = Def.Sprite {
		Texture=THEME:GetPathG("ScreenEvaluation", "fail hex");
		InitCommand=function(self)
			self:zoomto(SCREEN_WIDTH,SCREEN_HEIGHT):customtexturerect(0,0,SCREEN_WIDTH*4/512,SCREEN_HEIGHT*4/512):Center()
		end;
		OnCommand=function(self)
			self:texcoordvelocity(0.3,0.3)
			self:diffusealpha(0):linear(1):diffusealpha(0.8)
		end;
	};
	
t[#t+1] = Def.Sprite {
		Texture="_scanline";
		InitCommand=function(self)
			self:zoomto(SCREEN_WIDTH,SCREEN_HEIGHT):customtexturerect(0,0,SCREEN_WIDTH*4,SCREEN_HEIGHT*4):Center()
		end;
		OnCommand=function(self)
			self:diffusealpha(0):linear(1):diffusealpha(9)
		end;
	};

t[#t+1] = Def.Sprite {
	  Texture="_dialog.png";
	  InitCommand=function(self) self:Center() end;
	  OnCommand=function(self) 
		self:zoom(1.2):glow(1,1,1,0.6):diffusealpha(0):skewx(-1.3)
		self:decelerate(0.2)
		self:skewx(0):zoom(0.75):diffusealpha(1):glow(1,1,1,0):sleep(3) end;
};

t[#t+1] = Def.Quad {
		InitCommand=function(self) self:Center():zoomto(SCREEN_WIDTH+1,SCREEN_HEIGHT):draworder(10000) end;
		OnCommand=function(self) self:diffusealpha(0):diffuse(color("0,0,0,0")):sleep(failWait):diffusealpha(1) end;
	};

t[#t+1] = Def.Quad {
		InitCommand=function(self) self:Center():horizalign(center):zoomto(SCREEN_WIDTH+1,SCREEN_HEIGHT):draworder(10000):diffuse(color("#FF7878")) end;
		OnCommand=function(self) self:diffusealpha(0):sleep(failWait)
		self:diffusealpha(1):linear(0.3):zoomto(SCREEN_WIDTH,10):decelerate(0.3):zoomto(0,10):diffusealpha(0) end;
	};
t[#t+1] = Def.Quad {
		InitCommand=function(self) self:Center():horizalign(center):zoomto(SCREEN_WIDTH+1,SCREEN_HEIGHT):draworder(10000):diffuse(color("#FF7878")) end;
		OnCommand=function(self) self:diffusealpha(0):sleep(failWait)
		self:diffusealpha(1):decelerate(0.3):diffusealpha(0) end;
	};
t[#t+1] = LoadActor(THEME:GetPathS("ScreenGameplay", "failure")) .. {
		StartTransitioningCommand=function(self)
			self:play();
		end;
	};	
return t